--- src/bund.c.orig	2010-02-22 02:26:46.000000000 +0600
+++ src/bund.c	2010-11-21 19:01:30.000000000 +0600
@@ -1223,6 +1223,7 @@
 	if (BundNgInit(b) < 0) {
 	    Log(LG_ERR, ("[%s] Bundle netgraph initialization failed", b->name));
 	    gBundles[b->id] = NULL;
+	    IfaceFreeDescription(&b->iface);
 	    Freee(b);
 	    return(0);
 	}
@@ -1244,6 +1245,7 @@
     int		k;
 
     Log(LG_BUND, ("[%s] Bundle: Shutdown", b->name));
+    IfaceFreeDescription(&b->iface);
     for (k = 0; k < NG_PPP_MAX_LINKS; k++) {
 	if ((l = b->links[k]) != NULL)
 	    if (!l->stay)
@@ -1308,6 +1310,10 @@
 
   /* Show configuration */
   Printf("Configuration:\r\n");
+  Printf("\tDesc. template : %s\r\n",
+	sb->iface.desc_template ? sb->iface.desc_template : "<none>");
+  Printf("\tDescription    : %s\r\n",
+	sb->iface.description ? sb->iface.description : "<none>");
   Printf("\tRetry timeout  : %d seconds\r\n", sb->conf.retry_timeout);
   Printf("\tBW-manage:\r\n");
   Printf("\t  Period       : %d seconds\r\n", sb->conf.bm_S);
